/**
 * PCM dispatch driver Z for FMP <ocye> for Windows
 * PPZ8 Extender "Z8X" for Windows
 *
 * Original PDZF Programmed by H.Yoshimura ( Kossestsu-Inryo )
 * Original Z8X & Windows Version Programmed by Y.Taniuchi ( TAN-Y )
 *
 * Special Thanks C60 ( WinFMP & PPZ8L.cpp/.h ), Kossetsu-Inryo ( PDZF )
 */

#ifndef _PDZFZ8X_WORK_
#define _PDZFZ8X_WORK_

#include <WinFMPImport.h>

#pragma pack(1)

/**
 * [N`wb_
 *
 * @version 0.1.0
 * @author Y.Taniuchi
 */

#define EXTPPZ8SEQMODE_DISABLE			(0x0000)
#define EXTPPZ8SEQMODE_ENABLE			(0x0001)
#define EXTPPZ8SEQMODE_Z8X				(0x0002 | EXTPPZ8SEQMODE_ENABLE)
#define EXTPPZ8SEQMODE_PDZF_STANDARD	(0x0004 | EXTPPZ8SEQMODE_ENABLE)
#define EXTPPZ8SEQMODE_PDZF_ENHANCED	(0x0008 | EXTPPZ8SEQMODE_ENABLE)
#define EXTPPZ8SEQMODE_ALLENABLE		(0xffff)

#define EXS_KEYON		(0x0001)
#define EXS_BEND		(0x0002)
#define EXS_SLUR		(0x0004)
#define EXS_LEGATO		(0x0008)
#define EXS_KEYOFF		(0x1000)
#define EXS_RELEASE		(0x2000)
#define EXS_SUSTAIN		(0x4000)
#define EXS_ATTACK		(0x8000)
#define EXS_INIT		(0xe000)		//ɏtO

#define SW_STANDARD		(0x0001)		//X^_[h[h
#define SW_ENHANCED		(0x0002)		//GnXg[h
#define SW_LEGATO		(0x0004)		//K[gI
#define SW_MULTI		(0x0008)		//}`eBo[

/**
 * PDZF sb`xh[N
 */
typedef struct tagEXPITS
{
	char cPitSdat;			//sb`xhωl
	char cPitSdelay;		//fBCl
	char cPitSspeed;		//Xs[h
	char cPitScnt;			//Xs[hJE^
	DWORD dwPitSwave;		//ڕWg
	BYTE bPitStarget;		//ڕW
}EXPITS;


/**
 * PDZF FM/SSGp[gp
 */
typedef struct EXPATS
{
	BYTE bPatSlength;		//ۑ(L[I擾p)
	BYTE bPatSoldstat;		//POPartSstatusۑ
	BYTE bPatSbefore;		//݂̉
	BYTE bPatSoct;			//IN^[u
	char cPatSdetune;		//fB`[ۑ
	BYTE bPatSpan;			//p|bgۑ
	BYTE bPatStmpvol;		//݂̏o͉
	BYTE bPatSvol;			//ɂȂ鉹
	char cPatSenvvol;		//ʂ̃Gx[vɂω
	char cPatSenv_cnt;		//Gx[vpJE^
	char cPatSenv_dep;		//Gx[vpJE^
	BYTE bPatStone;			//Fԍۑ
	WORD wPatSstatus;		//PDZF̃Xe[^XtO
	WORD wPatSpcmfreq;		//oblTvOgۑ
	DWORD dwPatSwave;		//ۂ̉g
	DWORD dwPatSwave2;		//Ỏg
	DWORD dwPatSwave3;		//g(Tu)
	int iPatSdetwave;		//fB`[ɂ邸̗
	DWORD dwPatSloop_s;		//[vJnItZbgۑ
	DWORD dwPatSloop_e;		//[vIItZbgۑ

	EXPITS PitS;			//sb`xhp[N
	LFOS PatSlfo1;			//kenO
	LFOS PatSlfo2;			//kenP
}EXPATS;


/**
 * PDZFY[N
 */
typedef struct tagEXRHYS
{
	BYTE bRhySswitch;		//g̃IEIt
	BYTE bRhySlength;		//ۑ(L[I擾p)
	BYTE bRhySkeyon;		//ƂŃL[ItO
	BYTE bRhySbit;			//ݏ̉F̃rbgԍ
	BYTE bRhySvol;			//ʕۑ
	BYTE bRhySprog1;		//FԍP
	BYTE bRhySprog2;		//FԍQ
	BYTE bRhySprog3;		//FԍR
	BYTE bRhySprog4;		//FԍS
	BYTE bRhySnote1;		//P
	BYTE bRhySnote2;		//Q
	char cRhySpan1;			//p|bgP
	char cRhySpan2;			//p|bgQ
	char cRhySpanBefore;	//Õp
	BYTE bRhySvolBefore;	//Õ{[
	BYTE bRhySnteBefore;	//Ỏ
}EXRHYS;


/**
 * PDZF[N\
 */
typedef struct tagPDZFWORK
{
	EXPATS aEXpats[6];
	EXRHYS EXrhy;
	LFOS EXlfo;
	BYTE bExtended;
	BYTE bFade;
}PDZFWORK;


/**
 * Z8Xp[g[N\
 */
typedef struct tagZ8XPART
{
	BYTE bFlag;					//tO
	BYTE bNote;					//f[^
	BYTE bVolume;				//ʒl
	BYTE bPan;					//p
	WORD wLFOwav;				//ken^f`[l
	short sEnvVol;				//Gx[vɂ鉹ʕω̉Zl
	BYTE bEnvCnt;				//Gx[vJE^
	short sLFO;					//kenl
	short sLFOadd;				//PɉZkenl
	byte bLFOcnt_w;				//kenEGCgJE^
	byte bLFOcnt;				//kenJE^
}Z8XPART;

//Z8X_S_Flag	db	?	;bit 0 = L[IǂtO
//				;bit 1 = L[It邩ǂtO
//				;bit 2 = Gx[v Attack Length (AL)
//				;bit 3 = Gx[v Sustain Rate  (SR)
//				;bit 4 = Gx[v Release Rate  (RR)
//				;bit 5 = L[IttO
//				;bit 6 = ken Delay tO
//				;bit 7 = ken 쒆tO

#define Z8XFLAG_KEYON_NOW 0x01
#define Z8XFLAG_KEYOFF 0x02
#define Z8XFLAG_ENV_AL 0x04
#define Z8XFLAG_ENV_SR 0x08
#define Z8XFLAG_ENV_RR 0x10
#define Z8XFLAG_KEYOFF_NOW 0x20
#define Z8XFLAG_LFO_DELAY 0x40
#define Z8XFLAG_LFO_NOW 0x80

/**
 * Z8X[N\
 */
typedef struct tagZ8XWORK
{
	Z8XPART aZ8XParts[3];
}Z8XWORK;

#pragma pack()

#endif
