PDZF / Z8X for Windows 拡張APIリファレンス
=====

## 目的

WinFMP + PDZFZ8X 状態でPDZF / Z8X側の操作をしたい場合に使用します。
通常のWinFMPのみを使用するアプリに影響が出ないような仕様になっています。


## 使い方

WinFMP Ver.0.18 以降より IWINFMP::QueryPDZFZ8XInterface メソッドが追加されています。
このメソッドを利用することで PDZFZ8XWin の制御インターフェースであるIPDZFZ8X が取得できます。
取得に失敗した場合は PDZFZ8XWin は使用できません。

IPDZFZ8X の使用方法は PDZFZ8XWin Ver.1.x 系から変更ありません。


## メソッド説明

### GetVersion

```cpp
virtual DWORD STDMETHODCALLTYPE GetVersion() = 0;
```

バージョン情報を取得する。

|    |    |
| -- | -- |
| 引数 | なし |
| 戻り値 | バージョン情報 (0xAABBCCCC : AA = Major / BB = Minor(intf change) / CCCC = Minor) |

バージョン情報を取得します。PDZFZ8X拡張APIのインターフェースに変更があった
場合はAAもしくはBBが変更になります。現在は0x0101????です。
このバージョンはバージョンリソースで取得できるバージョンと対応しています。
(AA.BB.CC.xxxx)


### GetExtendPPZ8SequenceMode

```cpp
virtual DWORD STDMETHODCALLTYPE GetExtendPPZ8SequenceMode() = 0;
```

拡張シーケンスモードを取得します。

引数    なし
戻り値  拡張シーケンスモード。
        EXTPPZ8SEQMODE_～の定数に対応するビットで判断します。

設定されている拡張シーケンスモードを設定します。
SetExtendPPZ8SequenceModeで設定された値を取得します。
デフォルトはEXTPPZ8SEQMODE_ALLENABLEです。


### SetExtendPPZ8SequenceMode

```cpp
virtual HRESULT STDMETHODCALLTYPE SetExtendPPZ8SequenceMode(DWORD dwMode) = 0;
```

拡張シーケンスモードを設定します。

|    |    |    |
| -- | -- | -- |
| 引数 | dwMode | 拡張シーケンスモード |
| 戻り値 | | 処理結果 |

拡張シーケンスモードを設定します。
拡張シーケンスのサポート範囲を定義したい場合に使用します。
Z8XやPDZFを無効にすることができます。無効にしておくと、Z8XやPDZFの対応データでも拡張シーケンス処理を行いません。
デフォルトはEXTPPZ8SEQMODE_ALLENABLEに設定されています。


### GetPlayingExtendPPZ8SequenceStatus

```cpp
virtual DWORD STDMETHODCALLTYPE GetPlayingExtendPPZ8SequenceStatus() = 0;
```

現在演奏中の拡張シーケンスモードを取得します。

|    |    |
| -- | -- |
| 引数 | なし |
| 戻り値 | 拡張シーケンスモード。EXTPPZ8SEQMODE_～の定数に対応するビットで判断します。 |

現在演奏中のシーケンスモードを取得します。
PDZFのデータを演奏している場合は、EXTPPZ8SEQMODE_PDZF_ENHANCEDの値が取得されます。


### GetPDZFWork

```cpp
virtual HRESULT STDMETHODCALLTYPE GetPDZFWork(PDZFWORK **ppPDZFWork) = 0;
```

PDZFのワークを取得する。

|    |    |    |
| -- | -- | -- |
| 引数 | ppPDZFWork | ワークへのポインタ取得先 |
| 戻り値 | | 処理結果 |

ワークの内容は原則的には書き換えないでください。


### GetZ8XWork

```cpp
virtual HRESULT STDMETHODCALLTYPE GetZ8XWork(Z8XWORK **ppZ8XWork) = 0;
```

Z8Xのワークを取得する。

|    |    |    |
| -- | -- | -- |
| 引数 | ppZ8XWork | ワークへのポインタ取得先 |
| 戻り値 | | 処理結果 |

ワークの内容は原則的には書き換えないでください。


### RegisterTimerBNotify

```cpp
virtual HRESULT STDMETHODCALLTYPE RegisterTimerBNotify(
    ITimerBNotify *pRegistNotify,ITimerBNotify **ppOldNotify) = 0;
```

TimerBイベントを登録する。

|    |    |    |
| -- | -- | -- |
| 引数 | pRegisterNotify | 新しく登録するイベントインターフェース |
| | ppOldNotify | 以前登録されていたインターフェースへの取得先ポインタ。取得する必要がない場合はNULL。|
| 戻り値 | | 処理結果 |

TimerBイベントを登録します。
ITimerBNotifyインターフェースを実装したクラスのポインタを設定してください。
getpcmdataでサンプルを取得する際、内部処理でいわゆる「TimerB割り込みが発生」のタイミングでOnTimerBメソッドが呼ばれます。

注意点として、98DOSのFMPと違い、そもそもgetpcmdataは演奏と非同期で処理されています（getpcmdataでwaveデータを取得し、そのwaveを再生しているので当たり前ですが）。
そのため、このタイミングに合わせて何か処理をしよう、としても実質意味ないです。
このタイミングで演奏処理が入りワークの更新があります。したがってそのタイミングでFMPワークの内容を取得したいとか、演奏に同期してワークや演奏結果に干渉したい
（PDZFZ8Xでやってることです）とか、そういうのでもない限り意味はないと思います。

イベントインターフェースの登録は一つだけです。同時に二つ以上の登録はできません。

ITimerBNotify::OnTimerBですが、

```cpp
virtual HRESULT STDMETHODCALLTYPE OnTimerB(
    BOOL blTimerBNotify, Stereo16bit *pSamples, int iSampleCnt) = 0;
```

blTimerBNotifyは今回の呼び出しがTimerB割り込み（相当）が発生したのかどうかのフラグです。
TRUEの場合は発生したのでワークの更新が起きています。
FALSEの場合は割り込みと無関係なのでワークの更新はありません。
FALSEは次の割り込みが発生する前にgetpcmdataで指定した長さのサンプル数に達した場合、それまでの分を処理するために発生します。

pSamlpesは直前のOnTimerB呼び出しから今回の呼び出しまでの間の長さのサンプルが入ったポインタで、iSampleCntはそのサンプル数です。
pSamplesは処理結果そのものですので、これに対して別の音をミックスするのも可能です。


