﻿/**
 * PCM dispatch driver Z for FMP <ＰＤＺＦ> for Windows
 * PPZ8 Extender "Z8X" for Windows
 *
 * Original PDZF Programmed by H.Yoshimura ( Kossestsu-Inryo )
 * Original Z8X & Windows Version Programmed by Y.Taniuchi ( TAN-Y )
 *
 * Special Thanks C60 ( WinFMP & PPZ8L.cpp/.h ), Kossetsu-Inryo ( PDZF )
 */

#ifndef _PDZFZ8X_WORK_
#define _PDZFZ8X_WORK_

#include <WinFMPImport.h>

#pragma pack(1)

/**
 * ワーク定義ヘッダ
 *
 * @version 0.1.0
 * @author Y.Taniuchi
 */

#define EXTPPZ8SEQMODE_DISABLE			(0x0000)
#define EXTPPZ8SEQMODE_ENABLE			(0x0001)
#define EXTPPZ8SEQMODE_Z8X				(0x0002 | EXTPPZ8SEQMODE_ENABLE)
#define EXTPPZ8SEQMODE_PDZF_STANDARD	(0x0004 | EXTPPZ8SEQMODE_ENABLE)
#define EXTPPZ8SEQMODE_PDZF_ENHANCED	(0x0008 | EXTPPZ8SEQMODE_ENABLE)
#define EXTPPZ8SEQMODE_ALLENABLE		(0xffff)

#define EXS_KEYON		(0x0001)
#define EXS_BEND		(0x0002)
#define EXS_SLUR		(0x0004)
#define EXS_LEGATO		(0x0008)
#define EXS_KEYOFF		(0x1000)
#define EXS_RELEASE		(0x2000)
#define EXS_SUSTAIN		(0x4000)
#define EXS_ATTACK		(0x8000)
#define EXS_INIT		(0xe000)		//発音時に初期化するフラグ

#define SW_STANDARD		(0x0001)		//スタンダードモード
#define SW_ENHANCED		(0x0002)		//エンハンストモード
#define SW_LEGATO		(0x0004)		//レガートオン
#define SW_MULTI		(0x0008)		//マルチティンバー

/**
 * PDZF ピッチベンドワーク
 */
typedef struct tagEXPITS
{
	char cPitSdat;			//ピッチベンド変化値
	char cPitSdelay;		//ディレイ値
	char cPitSspeed;		//スピード
	char cPitScnt;			//スピードカウンタ
	DWORD dwPitSwave;		//目標周波数
	BYTE bPitStarget;		//目標音程
}EXPITS;


/**
 * PDZF FM/SSGパート用
 */
typedef struct EXPATS
{
	BYTE bPatSlength;		//音長保存(キーオン取得用)
	BYTE bPatSoldstat;		//１つ前のPartSstatusを保存
	BYTE bPatSbefore;		//現在の音程
	BYTE bPatSoct;			//オクターブ
	char cPatSdetune;		//ディチューン保存
	BYTE bPatSpan;			//パンポット保存
	BYTE bPatStmpvol;		//現在の出力音量
	BYTE bPatSvol;			//基準になる音量
	char cPatSenvvol;		//音量のエンベロープによる変化
	char cPatSenv_cnt;		//エンベロープ処理用カウンタ
	char cPatSenv_dep;		//エンベロープ処理用カウンタ
	BYTE bPatStone;			//音色番号保存
	WORD wPatSstatus;		//PDZF内部のステータスフラグ
	WORD wPatSpcmfreq;		//ＰＣＭサンプリング周波数保存
	DWORD dwPatSwave;		//実際の音程周波数
	DWORD dwPatSwave2;		//直前の音程周波数
	DWORD dwPatSwave3;		//基準周波数(サブ)
	int iPatSdetwave;		//ディチューンによるずれの量
	DWORD dwPatSloop_s;		//ループ開始オフセット保存
	DWORD dwPatSloop_e;		//ループ終了オフセット保存

	EXPITS PitS;			//ピッチベンド用ワーク
	LFOS PatSlfo1;			//ＬＦＯ＃０
	LFOS PatSlfo2;			//ＬＦＯ＃１
}EXPATS;


/**
 * PDZFリズムワーク
 */
typedef struct tagEXRHYS
{
	BYTE bRhySswitch;		//拡張処理のオン・オフ
	BYTE bRhySlength;		//音長保存(キーオン取得用)
	BYTE bRhySkeyon;		//あとでキーオンするフラグ
	BYTE bRhySbit;			//現在処理中の音色のビット番号
	BYTE bRhySvol;			//音量保存
	BYTE bRhySprog1;		//音色番号１
	BYTE bRhySprog2;		//音色番号２
	BYTE bRhySprog3;		//音色番号３
	BYTE bRhySprog4;		//音色番号４
	BYTE bRhySnote1;		//音程１
	BYTE bRhySnote2;		//音程２
	char cRhySpan1;			//パンポット１
	char cRhySpan2;			//パンポット２
	char cRhySpanBefore;	//前回のパン
	BYTE bRhySvolBefore;	//前回のボリューム
	BYTE bRhySnteBefore;	//前回の音程
}EXRHYS;


/**
 * PDZFワーク構造体
 */
typedef struct tagPDZFWORK
{
	EXPATS aEXpats[6];
	EXRHYS EXrhy;
	LFOS EXlfo;
	BYTE bExtended;
	BYTE bFade;
}PDZFWORK;


/**
 * Z8Xパートワーク構造体
 */
typedef struct tagZ8XPART
{
	BYTE bFlag;					//フラグ
	BYTE bNote;					//音程データ
	BYTE bVolume;				//音量値
	BYTE bPan;					//パン
	WORD wLFOwav;				//ＬＦＯ／デチューン値
	short sEnvVol;				//エンベロープによる音量変化の加算値
	BYTE bEnvCnt;				//エンベロープカウンタ
	short sLFO;					//ＬＦＯ値
	short sLFOadd;				//１回に加算するＬＦＯ値
	byte bLFOcnt_w;				//ＬＦＯウエイトカウンタ
	byte bLFOcnt;				//ＬＦＯカウンタ
}Z8XPART;

//Z8X_S_Flag	db	?	;bit 0 = キーオン中かどうかフラグ
//				;bit 1 = キーオフをするかどうかフラグ
//				;bit 2 = エンベロープ Attack Length (AL)
//				;bit 3 = エンベロープ Sustain Rate  (SR)
//				;bit 4 = エンベロープ Release Rate  (RR)
//				;bit 5 = キーオフ中フラグ
//				;bit 6 = ＬＦＯ Delay 中フラグ
//				;bit 7 = ＬＦＯ 動作中フラグ

#define Z8XFLAG_KEYON_NOW 0x01
#define Z8XFLAG_KEYOFF 0x02
#define Z8XFLAG_ENV_AL 0x04
#define Z8XFLAG_ENV_SR 0x08
#define Z8XFLAG_ENV_RR 0x10
#define Z8XFLAG_KEYOFF_NOW 0x20
#define Z8XFLAG_LFO_DELAY 0x40
#define Z8XFLAG_LFO_NOW 0x80

/**
 * Z8Xワーク構造体
 */
typedef struct tagZ8XWORK
{
	Z8XPART aZ8XParts[3];
}Z8XWORK;

#pragma pack()

#endif
